/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.cascade;

import java.util.Collection;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.listener.DeleteByIdListener;
import org.codefilarete.tool.collection.Iterables;

public abstract class BeforeDeleteByIdCollectionCascader<TRIGGER, TARGET>
implements DeleteByIdListener<TRIGGER> {
    private final EntityPersister<TARGET, ?> persister;

    public BeforeDeleteByIdCollectionCascader(EntityPersister<TARGET, ?> persister) {
        this.persister = persister;
        this.persister.addDeleteByIdListener(new DeleteByIdListener<TARGET>(){

            public void afterDeleteById(Iterable<? extends TARGET> entities) {
                BeforeDeleteByIdCollectionCascader.this.postTargetDelete(entities);
            }
        });
    }

    public EntityPersister<TARGET, ?> getPersister() {
        return this.persister;
    }

    public void beforeDeleteById(Iterable<? extends TRIGGER> entities) {
        this.persister.deleteById((Iterable)Iterables.stream(entities).flatMap(c -> this.getTargets(c).stream()).collect(Collectors.toList()));
    }

    protected abstract void postTargetDelete(Iterable<TARGET> var1);

    protected abstract Collection<TARGET> getTargets(TRIGGER var1);
}

